import pickle
import numpy as np
import pandas as pd

from PIL import Image
from skimage.metrics import structural_similarity
import imageio

def compare_plots(ai_output, reference_output):  
    # Load the images  
    image1 = Image.open(ai_output)  
    image2 = Image.open(reference_output)  
    
    # Define the new size (width, height)  
    new_size = (800, 600)  
    
    # Resize the images  
    resized_image1 = image1.resize(new_size, Image.Resampling.LANCZOS)  
    resized_image2 = image2.resize(new_size, Image.Resampling.LANCZOS)  
    
    # Save the resized images  
    resized_image1.save("resized_plot1.png")  
    resized_image2.save("resized_plot2.png")  

    image1 = imageio.imread("resized_plot1.png", mode='L')  
    image2 = imageio.imread("resized_plot2.png", mode='L')  
    
    ssim = structural_similarity(image1, image2, data_range=1)  
    
    return ssim
    
# Replace <ai_res> and <ref_res> with the actual AI and reference outputs
machine_result = "pred_result/updated_odds_change_for_player_1.png"

reference_result = "ref_result/updated_odds_change_for_player_1.png"
  
# Call the compare_plots function with both outputs
try:
    result = compare_plots(machine_result, reference_result)
except:
    result = False

print(result)

# Replace <ai_res> and <ref_res> with the actual AI and reference outputs
machine_result = "pred_result/updated_odds_change_for_player_2.png"

reference_result = "ref_result/updated_odds_change_for_player_2.png"
  
# Call the compare_plots function with both outputs
try:
    result = compare_plots(machine_result, reference_result)
except:
    result = False

print(result)